---
title: Get started · Cloudflare Fundamentals docs
description: Before you can begin using Cloudflare products, first create an account.
lastUpdated: 2025-09-08T19:30:16.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/get-started/
  md: https://developers.cloudflare.com/fundamentals/get-started/index.md
---

Before you can begin using Cloudflare products, first [create an account](https://developers.cloudflare.com/fundamentals/account/create-account/).

## Learn about Cloudflare's offerings

### Build

**Build** is where developers create and deploy simple sites and full-stack applications on the [Workers compute platform](https://developers.cloudflare.com/workers/), and connect them to storage and database primitives like [KV](https://developers.cloudflare.com/kv/) (key-value data store), [D1](https://developers.cloudflare.com/d1/) (SQL database), [R2](https://developers.cloudflare.com/r2/) (object storage), [Queues](https://developers.cloudflare.com/queues/) (asynchronous messaging), [Durable Objects](https://developers.cloudflare.com/durable-objects/) (stateful coordination), and more.

Our compute, orchestration, AI, storage, media, and security services are integrated, so you can quickly extend existing apps or launch new ones while Cloudflare's global network takes care of infrastructure, scaling, and performance for you.

### Protect & Connect

**Protect & Connect** is where you establish fast and reliable connections between your websites, apps, and users, while protecting them from attackers and unwanted traffic.

Application security and performance focuses on resources available on the public Internet. Manage delivery performance by controlling and speeding up primarily [Layer 7 (Application) traffic](https://developers.cloudflare.com/fundamentals/reference/network-layers/), in addition to managing media such as video and images. Get started by [onboarding a domain](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/).

Zero Trust protects private, internal users/devices and the resources they access. [Get started with Zero Trust](https://developers.cloudflare.com/cloudflare-one/setup/).

Network services extend protection and acceleration to cloud, on-premise, or hybrid networks, and you can also manage network connections and optimize Layer 3 (Network) and 4 (Transport) traffic. Get started with [Magic Transit](https://developers.cloudflare.com/magic-transit/) or [Magic WAN](https://developers.cloudflare.com/magic-wan/).
