---
title: Plans | Cloudflare Docs
description: View the products and features available to you based on your Cloudflare plan.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/plans/
  md: https://developers.cloudflare.com/plans/index.md
---

A feature-level companion to our [Plans and Pricing page](https://www.cloudflare.com/plans/)

(may not include [all features](#missing-features))

## Account

### Cloudflare dashboard single sign-on

**Link:** [Cloudflare dashboard single sign-on](https://developers.cloudflare.com/fundamentals/manage-members/dashboard-sso/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Version Management

**Link:** [Version Management](https://developers.cloudflare.com/version-management/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Zone holds

**Link:** [Zone holds](https://developers.cloudflare.com/fundamentals/account/account-security/zone-holds/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

## Analytics

### GraphQL Analytics API

**Link:** [GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Instant Logs

**Link:** [Instant Logs](https://developers.cloudflare.com/logs/instant-logs/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

### Logpull

**Link:** [Logpull](https://developers.cloudflare.com/logs/instant-logs/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Logpush

**Link:** [Logpush](https://developers.cloudflare.com/logs/logpush/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Traffic analytics

**Link:** [Traffic analytics](https://developers.cloudflare.com/analytics/account-and-zone-analytics/zone-analytics/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Level of detail**

* **Free:** Requests, bandwidth, unique visitors
* **Lite:** Requests, bandwidth, unique visitors
* **Pro:** Same as Free, but able to see historical trends and filter by characteristics
* **Pro Plus:** Same as Free, but able to see historical trends and filter by characteristics
* **Business:** Same as Pro
* **Enterprise:** Same as Pro

**Historical time**

* **Free:** 30 days
* **Lite:** 30 days
* **Pro:** 7 days
* **Pro Plus:** 7 days
* **Business:** 30 days
* **Enterprise:** 30 days

## Cache

### Always Online

**Link:** [Always Online](https://developers.cloudflare.com/cache/how-to/always-online/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Crawl interval**

Available on all plans

* **Free:** Every 30 days
* **Lite:** Every 30 days
* **Pro:** Every 15 days
* **Pro Plus:** Every 15 days
* **Business:** Every 5 days
* **Enterprise:** Every 5 days

### Browser Cache TTL

**Link:** [Browser Cache TTL](https://developers.cloudflare.com/cache/how-to/edge-browser-cache-ttl/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Minimum Browser Cache TTL (Page Rules)**

* **Free:** 2 minutes
* **Lite:** 2 minutes
* **Pro:** 2 minutes
* **Pro Plus:** 2 minutes
* **Business:** 2 minutes
* **Enterprise:** 30 seconds

**Minimum Browser Cache TTL**

* **Free:** 1 second
* **Lite:** 1 second
* **Pro:** 1 second
* **Pro Plus:** 1 second
* **Business:** 1 second
* **Enterprise:** 1 second

**Default Browser Cache TTL**

* **Free:** 4 hours
* **Lite:** 4 hours
* **Pro:** 4 hours
* **Pro Plus:** 4 hours
* **Business:** 4 hours
* **Enterprise:** 4 hours

### Cache analytics

**Link:** [Cache analytics](https://developers.cloudflare.com/cache/performance-review/cache-analytics/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Retention period**

* **Free:** N/A
* **Lite:** N/A
* **Pro:** 7 days
* **Pro Plus:** 7 days
* **Business:** 30 days
* **Enterprise:** 30 days

### Cache keys

**Link:** [Cache keys](https://developers.cloudflare.com/cache/how-to/cache-keys/)

**Cache deception armor**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Cache by device type**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Ignore query string**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Sort query string**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Query string**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Headers**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Cookie**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Host**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**User features**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Set caching level

**Link:** [Set caching level](https://developers.cloudflare.com/cache/how-to/set-caching-levels/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Cache reserve

**Link:** [Cache reserve](https://developers.cloudflare.com/cache/advanced-configuration/cache-reserve/)

**Feature availability**

* **Free:** Paid add-on
* **Lite:** Paid add-on
* **Pro:** Paid add-on
* **Pro Plus:** Paid add-on
* **Business:** Paid add-on
* **Enterprise:** Paid add-on

### Cache Rules

**Link:** [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 10
* **Lite:** 10
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

### Cache by status code

**Link:** [Cache by status code](https://developers.cloudflare.com/cache/how-to/configure-cache-status-code/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Crawler Hints

**Link:** [Crawler Hints](https://developers.cloudflare.com/cache/advanced-configuration/crawler-hints/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### CSAM Scanning Tool

**Link:** [CSAM Scanning Tool](https://developers.cloudflare.com/cache/reference/csam-scanning/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Development mode

**Link:** [Development mode](https://developers.cloudflare.com/cache/reference/development-mode/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Edge Cache TTL

**Link:** [Edge Cache TTL](https://developers.cloudflare.com/cache/how-to/edge-browser-cache-ttl/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Minimum Edge Cache TTL**

* **Free:** 2 hours
* **Lite:** 2 hours
* **Pro:** 1 hour
* **Pro Plus:** 1 hour
* **Business:** 1 second
* **Enterprise:** 1 second

### ETag Headers

**Link:** [ETag Headers](https://developers.cloudflare.com/cache/reference/etag-headers/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Purge cache

**Link:** [Purge cache](https://developers.cloudflare.com/cache/how-to/purge-cache/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Purge options**

* **Free:** URL, Hostname, Tag, Prefix, and Purge Everything
* **Lite:** URL, Hostname, Tag, Prefix, and Purge Everything
* **Pro:** URL, Hostname, Tag, Prefix, and Purge Everything
* **Pro Plus:** URL, Hostname, Tag, Prefix, and Purge Everything
* **Business:** URL, Hostname, Tag, Prefix, and Purge Everything
* **Enterprise:** URL, Hostname, Tag, Prefix, and Purge Everything

### Purge limits for hostname, tag, prefix URL, and purge everything.

**Link:** [Purge limits for hostname, tag, prefix URL, and purge everything.](https://developers.cloudflare.com/cache/how-to/purge-cache/)

**Requests**

Available on all plans

* **Free:** 5 requests per minute
* **Lite:** 5 requests per minute
* **Pro:** 5 requests per second
* **Pro Plus:** 5 requests per second
* **Business:** 10 requests per second
* **Enterprise:** 50 requests per second

**Bucket size**

* **Free:** 25
* **Lite:** 25
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 500

**Max operations per request**

* **Free:** 100
* **Lite:** 100
* **Pro:** 100
* **Pro Plus:** 100
* **Business:** 100
* **Enterprise:** 100

### Single file purge

**Link:** [Single file purge](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-by-single-file/)

**URLs**

Available on all plans

* **Free:** 800 URLs per second
* **Lite:** 800 URLs per second
* **Pro:** 1500 URLs per second
* **Pro Plus:** 1500 URLs per second
* **Business:** 1500 URLs per second
* **Enterprise:** 3000 URLs per second

**Max operations per request**

* **Free:** 100
* **Lite:** 100
* **Pro:** 100
* **Pro Plus:** 100
* **Business:** 100
* **Enterprise:** 500

### Query string sort

**Link:** [Query string sort](https://developers.cloudflare.com/cache/advanced-configuration/query-string-sort/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Tiered cache

**Link:** [Tiered cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/)

**Tiered Cache**

Available on all plans

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Smart Topology**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Generic Global Topology**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Regional Tiered Cache**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Custom Topology**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Vary for images

**Link:** [Vary for images](https://developers.cloudflare.com/cache/advanced-configuration/vary-for-images/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

## DNS

### Advanced nameservers

**Link:** [Advanced nameservers](https://developers.cloudflare.com/dns/foundation-dns/advanced-nameservers/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Included with [Foundation DNS](https://developers.cloudflare.com/dns/foundation-dns/)

### CNAME flattening

**Link:** [CNAME flattening](https://developers.cloudflare.com/dns/cname-flattening/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Can customize**

Pro plans and above can customize

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Custom nameservers

**Link:** [Custom nameservers](https://developers.cloudflare.com/dns/nameservers/custom-nameservers/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

### DNS analytics

**Link:** [DNS analytics](https://developers.cloudflare.com/dns/additional-options/analytics/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Maximum time interval (zone)**

* **Free:** 7 days
* **Lite:** 7 days
* **Pro:** 31 days
* **Pro Plus:** 31 days
* **Business:** 31 days
* **Enterprise:** 62 days

**Maximum time interval (account)**

* **Free:** 7 days
* **Lite:** 7 days
* **Pro:** 7 days
* **Pro Plus:** 7 days
* **Business:** 7 days
* **Enterprise:** 62 days

**Historical data (zone)**

* **Free:** 8 days
* **Lite:** 8 days
* **Pro:** 31 days
* **Pro Plus:** 31 days
* **Business:** 31 days
* **Enterprise:** 62 days

**Historical data (account)**

* **Free:** 8 days
* **Lite:** 8 days
* **Pro:** 8 days
* **Pro Plus:** 8 days
* **Business:** 8 days
* **Enterprise:** 62 days

### DNSSEC

**Link:** [DNSSEC](https://developers.cloudflare.com/dns/dnssec/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### DNS Firewall

**Link:** [DNS Firewall](https://developers.cloudflare.com/dns/dns-firewall/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

**Historical data**

* **Free:** N/A
* **Lite:** N/A
* **Pro:** N/A
* **Pro Plus:** N/A
* **Business:** N/A
* **Enterprise:** 62 days

**Maximum time interval**

* **Free:** N/A
* **Lite:** N/A
* **Pro:** N/A
* **Pro Plus:** N/A
* **Business:** N/A
* **Enterprise:** 62 days

### Full zone setup

**Link:** [Full zone setup](https://developers.cloudflare.com/dns/zone-setups/full-setup/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Partial zone setup

**Link:** [Partial zone setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

### DNS records management

**Link:** [DNS records management](https://developers.cloudflare.com/dns/manage-dns-records/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of records per zone**

* **Free:** 1,000 for zones created before `2024-09-01 00:00:00 UTC`\
  200 for zones created on or after `2024-09-01 00:00:00 UTC`
* **Lite:** 1,000 for zones created before `2024-09-01 00:00:00 UTC`\
  200 for zones created on or after `2024-09-01 00:00:00 UTC`
* **Pro:** 3,500
* **Pro Plus:** 3,500
* **Business:** 3,500
* **Enterprise:** 3,500 (can be increased)

### DNS record comments

**Link:** [DNS record comments](https://developers.cloudflare.com/dns/manage-dns-records/reference/record-attributes/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Character limit**

* **Free:** 100
* **Lite:** 500
* **Pro:** 500
* **Pro Plus:** 500
* **Business:** 500
* **Enterprise:** 500

**Comments per record**

* **Free:** 1
* **Lite:** 1
* **Pro:** 1
* **Pro Plus:** 1
* **Business:** 1
* **Enterprise:** 1

### DNS record tags

**Link:** [DNS record tags](https://developers.cloudflare.com/dns/manage-dns-records/reference/record-attributes/)

**Feature availability**

* **Free:** No
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Name character limit (everything before the colon)**

* **Free:** N/A
* **Lite:** 32
* **Pro:** 32
* **Pro Plus:** 32
* **Business:** 32
* **Enterprise:** 32

**Value character limit (everything after the colon)**

* **Free:** N/A
* **Lite:** 100
* **Pro:** 100
* **Pro Plus:** 100
* **Business:** 100
* **Enterprise:** 100

**Tags per record**

* **Free:** N/A
* **Lite:** 20
* **Pro:** 20
* **Pro Plus:** 20
* **Business:** 20
* **Enterprise:** 20

### DNS zone transfers

**Link:** [DNS zone transfers](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Subdomain zone setup

**Link:** [Subdomain zone setup](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Subdomain delegation

**Link:** [Subdomain delegation](https://developers.cloudflare.com/dns/manage-dns-records/how-to/subdomains-outside-cloudflare/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Reverse zones

**Link:** [Reverse zones](https://developers.cloudflare.com/dns/additional-options/reverse-zones/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

## Email

### Email Routing

**Link:** [Email Routing](https://developers.cloudflare.com/email-routing/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Area 1 Email Security

**Link:** [Area 1 Email Security](https://developers.cloudflare.com/email-security/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

## Global configurations

### Lists

**Link:** [Lists](https://developers.cloudflare.com/waf/tools/lists/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of custom lists (any type)**

* **Free:** 1
* **Lite:** 10
* **Pro:** 10
* **Pro Plus:** 10
* **Business:** 10
* **Enterprise:** 1,000

**Max. number of list items (across all custom lists)**

* **Free:** 10,000
* **Lite:** 10,000
* **Pro:** 10,000
* **Pro Plus:** 10,000
* **Business:** 10,000
* **Enterprise:** 500,000

**IP lists**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Other custom lists (hostnames, ASNs)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Managed IP List: Cloudflare Open Proxies**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**All Managed IP Lists**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** With separate add-on

## Network

### 0-RTT Connection Resumption

**Link:** [0-RTT Connection Resumption](https://developers.cloudflare.com/speed/optimization/protocol/0-rtt-connection-resumption/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### gRPC

**Link:** [gRPC](https://developers.cloudflare.com/network/grpc-connections/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### IP Geolocation

**Link:** [IP Geolocation](https://developers.cloudflare.com/network/ip-geolocation/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### IPv6 Compatibility

**Link:** [IPv6 Compatibility](https://developers.cloudflare.com/network/ipv6-compatibility/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Can customize**

Only Enterprise can customize

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Max upload size

**Link:** [Max upload size](https://developers.cloudflare.com/cache/concepts/default-cache-behavior/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Max upload size**

* **Free:** 100 MB
* **Lite:** 100 MB
* **Pro:** 100 MB
* **Pro Plus:** 200 MB
* **Business:** 200 MB
* **Enterprise:** 500+ MB

### Onion Routing

**Link:** [Onion Routing](https://developers.cloudflare.com/network/onion-routing/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Pseudo IPv4

**Link:** [Pseudo IPv4](https://developers.cloudflare.com/network/pseudo-ipv4/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### True Client IP Header

**Link:** [True Client IP Header](https://developers.cloudflare.com/fundamentals/reference/http-headers/#true-client-ip-enterprise-plan-only)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### WebSockets

**Link:** [WebSockets](https://developers.cloudflare.com/network/websockets/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Volume of concurrent connections**

Varies by plan

* **Free:** Low (hobby projects)
* **Lite:** Low (hobby projects)
* **Pro:** Medium (Small businesses)
* **Pro Plus:** Medium (Small businesses)
* **Business:** High (important applications)
* **Enterprise:** Custom (mission-critical applications)

## Rules

### Bulk Redirects

**Link:** [Bulk Redirects](https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Bulk Redirect Rules**

* **Free:** 15
* **Lite:** 15
* **Pro:** 15
* **Pro Plus:** 15
* **Business:** 15
* **Enterprise:** 50

**Bulk Redirect Lists**

* **Free:** 5
* **Lite:** 5
* **Pro:** 5
* **Pro Plus:** 5
* **Business:** 5
* **Enterprise:** 25

**URL redirects across lists**

* **Free:** 10,000
* **Lite:** 10,000
* **Pro:** 25,000
* **Pro Plus:** 25,000
* **Business:** 50,000
* **Enterprise:** 1,000,000

### Cloud Connector (beta)

**Link:** [Cloud Connector (beta)](https://developers.cloudflare.com/rules/cloud-connector/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 10
* **Lite:** 10
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

### Configuration Rules

**Link:** [Configuration Rules](https://developers.cloudflare.com/rules/configuration-rules/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 10
* **Lite:** 10
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

### Compression Rules

**Link:** [Compression Rules](https://developers.cloudflare.com/rules/compression-rules/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 10
* **Lite:** 10
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

### Custom Errors

**Link:** [Custom Errors](https://developers.cloudflare.com/rules/custom-errors/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 0
* **Lite:** 0
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

**Number of assets**

* **Free:** 0
* **Lite:** 0
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

**Error Pages**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Origin Error Pages**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Origin Rules

**Link:** [Origin Rules](https://developers.cloudflare.com/rules/origin-rules/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 10
* **Lite:** 10
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

**Override Host header**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Override SNI**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Override DNS records**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Override destination port**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Page Rules

**Link:** [Page Rules](https://developers.cloudflare.com/rules/page-rules/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 3
* **Lite:** 3
* **Pro:** 20
* **Pro Plus:** 30
* **Business:** 50
* **Enterprise:** 125

### Snippets

**Link:** [Snippets](https://developers.cloudflare.com/rules/snippets/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of snippets**

* **Free:** 0
* **Lite:** 0
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

**Number of snippet subrequests**

* **Free:** 0
* **Lite:** 0
* **Pro:** 2
* **Pro Plus:** 2
* **Business:** 3
* **Enterprise:** 5

### Single Redirects

**Link:** [Single Redirects](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 10
* **Lite:** 10
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

**Wildcard support**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Regex support**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

### Transform Rules

**Link:** [Transform Rules](https://developers.cloudflare.com/rules/transform/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Active Transform Rules**

* **Free:** 10
* **Lite:** 10
* **Pro:** 25
* **Pro Plus:** 25
* **Business:** 50
* **Enterprise:** 300

**Regex support**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

## Scrape Shield

### Email Address Obfuscation

**Link:** [Email Address Obfuscation](https://developers.cloudflare.com/waf/tools/scrape-shield/email-address-obfuscation/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Hotlink Protection

**Link:** [Hotlink Protection](https://developers.cloudflare.com/waf/tools/scrape-shield/hotlink-protection/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

## Security

### Bot protection

**Link:** [Bot protection](https://developers.cloudflare.com/bots/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Bot analytics**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Bot Management variables**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

**Bot Fight Mode**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Super Bot Fight Mode**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### DDoS protection

**Link:** [DDoS protection](https://developers.cloudflare.com/ddos-protection/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Standard, unmetered DDoS protection (layers 3-7)**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**HTTP DDoS attack protection**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Network-layer (L3/4) DDoS attack protection**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Managed rules customization**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes, with Log action

**Proactive false positive detection for new rules**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Adaptive DDoS protection**

* **Free:** Only error adaptive rules
* **Lite:** Only error adaptive rules
* **Pro:** Only error adaptive rules
* **Pro Plus:** Only error adaptive rules
* **Business:** Only error adaptive rules
* **Enterprise:** Only error adaptive rules

**Traffic profiling signals for adaptive DDoS protection**

* **Free:** Error rates only
* **Lite:** Error rates only
* **Pro:** Error rates only
* **Pro Plus:** Error rates only
* **Business:** Error rates & historical trends
* **Enterprise:** Error rates & historical trends

**Advanced TCP Protection**

* **Free:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Lite:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Pro:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Pro Plus:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Business:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Enterprise:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers

**Advanced DNS Protection**

* **Free:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Lite:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Pro:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Pro Plus:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Business:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers
* **Enterprise:** Available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers

**Number of ruleset overrides allowed**

* **Free:** 1
* **Lite:** 1
* **Pro:** 1
* **Pro Plus:** 1
* **Business:** 1
* **Enterprise:** 1

**Alerts**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Security Events

**Link:** [Security Events](https://developers.cloudflare.com/waf/analytics/security-events/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Dashboard features**

* **Free:** Sampled logs only
* **Lite:** Sampled logs only
* **Pro:** All
* **Pro Plus:** All
* **Business:** All
* **Enterprise:** All

**Account-level dashboard**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Historical time**

* **Free:** Up to the last 24 hours
* **Lite:** Up to the last 24 hours
* **Pro:** Up to the last 24 hours
* **Pro Plus:** Up to the last 24 hours
* **Business:** Up to the last 72 hours
* **Enterprise:** Up to the last 30 days

**Export report**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Up to 500 events
* **Enterprise:** Up to 500 events

**Print report**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Security Analytics

**Link:** [Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Retention**

* **Free:** 7
* **Lite:** 7
* **Pro:** 31
* **Pro Plus:** 31
* **Business:** 31
* **Enterprise:** 90

**Query window**

* **Free:** 1
* **Lite:** 1
* **Pro:** 7
* **Pro Plus:** 7
* **Business:** 31
* **Enterprise:** 31

### Firewall rules (deprecated)

**Link:** [Firewall rules (deprecated)](https://developers.cloudflare.com/firewall/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 5
* **Lite:** 20
* **Pro:** 20
* **Pro Plus:** 40
* **Business:** 100
* **Enterprise:** 1,000

**Supported actions**

* **Free:** All except Log
* **Lite:** All except Log
* **Pro:** All except Log
* **Pro Plus:** All except Log
* **Business:** All except Log
* **Enterprise:** All

**Regex support**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

### IP Access Rules

**Link:** [IP Access Rules](https://developers.cloudflare.com/waf/tools/ip-access-rules/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 50,000
* **Lite:** 50,000
* **Pro:** 50,000
* **Pro Plus:** 50,000
* **Business:** 50,000
* **Enterprise:** 50,000, but can purchase more

**Block by country**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### WAF Managed Rules

**Link:** [WAF Managed Rules](https://developers.cloudflare.com/waf/managed-rules/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Free Managed Ruleset**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Cloudflare Managed Ruleset**

Available on paid plans

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Cloudflare OWASP Core Ruleset**

Available on paid plans

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Cloudflare Exposed Credentials Check**

Available on paid plans

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Cloudflare Sensitive Data Detection**

Enterprise with add-on

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

### WAF detections

**Link:** [WAF detections](https://developers.cloudflare.com/waf/detections/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Malicious uploads detection**

Enterprise with add-on

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

**Leaked credentials detection**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Leaked credentials fields**

* **Free:** Password Leaked
* **Lite:** Password Leaked
* **Pro:** Password Leaked, User and Password Leaked
* **Pro Plus:** Password Leaked, User and Password Leaked
* **Business:** Password Leaked, User and Password Leaked
* **Enterprise:** All leaked credentials fields

**Number of custom detection locations**

Enterprise-only

* **Free:** 0
* **Lite:** 0
* **Pro:** 0
* **Pro Plus:** 0
* **Business:** 0
* **Enterprise:** 10

**Attack score**

Business and Enterprise plans

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** One field only
* **Enterprise:** Yes

**Firewall for AI (beta)**

Enterprise-only

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### WAF custom rules

**Link:** [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 5
* **Lite:** 20
* **Pro:** 20
* **Pro Plus:** 40
* **Business:** 100
* **Enterprise:** 1,000

**Supported actions**

* **Free:** All except Log
* **Lite:** All except Log
* **Pro:** All except Log
* **Pro Plus:** All except Log
* **Business:** All except Log
* **Enterprise:** All

**Regex support**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

**Custom rulesets**

Enterprise with add-on

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

### Page Shield

**Link:** [Page Shield](https://developers.cloudflare.com/page-shield/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Script monitoring**

Available on all plans

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Connection monitoring**

Business and above

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

**Cookie monitoring**

Business and above

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

**Page attribution**

Business and above

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

**New Resources Alerts and New Domain Alerts**

Business and above

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

**Malicious script detection and alerting**

Enterprise with add-on

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** No

**Code change detection and alerting**

Enterprise with add-on

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** No

**Malicious connection detection and alerting**

Enterprise with add-on

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** No

**Cookie monitoring advanced fields**

Enterprise with add-on

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** No

**Number of policies (positive blocking)**

Enterprise with add-on

* **Free:** 0
* **Lite:** 0
* **Pro:** 0
* **Pro Plus:** 0
* **Business:** 0
* **Enterprise:** 0

**Number of Logpush jobs**

Enterprise with add-on

* **Free:** 0
* **Lite:** 0
* **Pro:** 0
* **Pro Plus:** 0
* **Business:** 0
* **Enterprise:** 0

### Rate limiting rules (new version)

**Link:** [Rate limiting rules (new version)](https://developers.cloudflare.com/waf/rate-limiting-rules/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 1
* **Lite:** 1
* **Pro:** 2
* **Pro Plus:** 2
* **Business:** 5
* **Enterprise:** 5

### Rate Limiting (previous version)

**Link:** [Rate Limiting (previous version)](https://developers.cloudflare.com/waf/reference/legacy/old-rate-limiting/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 1
* **Lite:** 10
* **Pro:** 10
* **Pro Plus:** 15
* **Business:** 15
* **Enterprise:** 100

**Number of header rules**

* **Free:** 1
* **Lite:** 1
* **Pro:** 1
* **Pro Plus:** 10
* **Business:** 10
* **Enterprise:** 10

### User Agent Blocking

**Link:** [User Agent Blocking](https://developers.cloudflare.com/waf/tools/user-agent-blocking/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 10
* **Lite:** 50
* **Pro:** 50
* **Pro Plus:** 250
* **Business:** 250
* **Enterprise:** 1,000

### Zone Lockdown

**Link:** [Zone Lockdown](https://developers.cloudflare.com/waf/tools/zone-lockdown/)

**Feature availability**

* **Free:** No
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 0
* **Lite:** 3
* **Pro:** 3
* **Pro Plus:** 10
* **Business:** 10
* **Enterprise:** 200

### Turnstile

**Link:** [Turnstile](https://developers.cloudflare.com/turnstile/)

**Pricing**

* **Free:** Free
* **Lite:** Free
* **Enterprise:** Contact Sales

**Number of widgets**

* **Free:** Up to 20 widgets
* **Lite:** Up to 20 widgets
* **Enterprise:** Unlimited

**All widget types**

* **Free:** Yes
* **Lite:** Yes
* **Enterprise:** Yes

**Unlimited challenges (traffic or verification requests)**

* **Free:** Yes
* **Lite:** Yes
* **Enterprise:** Yes

**Hostname management**

* **Free:** 15 hostnames per widget
* **Lite:** 15 hostnames per widget
* **Enterprise:** Maximum of 200 hostnames per widget

**Any hostname widget (no preconfigured hostnames)**

* **Free:** No
* **Lite:** No
* **Enterprise:** Yes

**Analytics lookback**

* **Free:** 7 days maximum
* **Lite:** 7 days maximum
* **Enterprise:** 30 days maximum

**Pre-clearance support**

* **Free:** Yes
* **Lite:** Yes
* **Enterprise:** Yes

**Ephemeral IDs**

* **Free:** No
* **Lite:** No
* **Enterprise:** Yes

**Offlabel (remove Cloudflare branding)**

* **Free:** No
* **Lite:** No
* **Enterprise:** Yes

**WCAG 2.1 AA compliance**

* **Free:** Yes
* **Lite:** Yes
* **Enterprise:** Yes

**Community support**

* **Free:** Yes
* **Lite:** Yes
* **Enterprise:** Yes

## Spectrum

### Spectrum

**Link:** [Spectrum](https://developers.cloudflare.com/spectrum/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Paid add-on
* **Pro Plus:** Paid add-on
* **Business:** Paid add-on
* **Enterprise:** Yes

**TCP**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

**UDP**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

**HTTP**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

**HTTPS**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

**Minecraft (one app allowed)**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**SSH (one app allowed)**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**RDP (one app allowed)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

## Speed

### Automatic Platform Optimization

**Link:** [Automatic Platform Optimization](https://developers.cloudflare.com/automatic-platform-optimization/)

**Feature availability**

* **Free:** Paid add-on
* **Lite:** Paid add-on
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Brotli compression

**Link:** [Brotli compression](https://developers.cloudflare.com/speed/optimization/content/compression/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Early Hints

**Link:** [Early Hints](https://developers.cloudflare.com/cache/advanced-configuration/early-hints)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Enhanced HTTP/2 Prioritization

**Link:** [Enhanced HTTP/2 Prioritization](https://developers.cloudflare.com/speed/optimization/protocol/enhanced-http2-prioritization/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### HTTP/2

**Link:** [HTTP/2](https://developers.cloudflare.com/speed/optimization/protocol/http2/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Can customize**

Free customers cannot disable

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### HTTP/2 to Origin

**Link:** [HTTP/2 to Origin](https://developers.cloudflare.com/speed/optimization/protocol/http2-to-origin/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### HTTP/3 (with QUIC)

**Link:** [HTTP/3 (with QUIC)](https://developers.cloudflare.com/speed/optimization/protocol/http3/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Image Optimization

**Link:** [Image Optimization](https://developers.cloudflare.com/images/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Paid add-on
* **Pro Plus:** Paid add-on
* **Business:** Paid add-on
* **Enterprise:** Paid add-on

### Mirage (deprecated)

**Link:** [Mirage (deprecated)](https://developers.cloudflare.com/speed/optimization/images/mirage/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Polish

**Link:** [Polish](https://developers.cloudflare.com/images/polish/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Prefetch URLs

**Link:** [Prefetch URLs](https://developers.cloudflare.com/speed/optimization/content/prefetch-urls/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Rocket Loader

**Link:** [Rocket Loader](https://developers.cloudflare.com/speed/optimization/content/rocket-loader/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Speed Brain

**Link:** [Speed Brain](https://developers.cloudflare.com/speed/optimization/content/speed-brain/)

**Feature availability**

* **Free:** Enabled by default
* **Lite:** Enabled by default
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### TCP Turbo

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

## SSL/TLS

### Advanced Certificates

**Link:** [Advanced Certificates](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

**Feature availability**

* **Free:** Paid add-on
* **Lite:** Paid add-on
* **Pro:** Paid add-on
* **Pro Plus:** Paid add-on
* **Business:** Paid add-on
* **Enterprise:** Paid add-on

### Authenticated origin pull

**Link:** [Authenticated origin pull](https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Backup Certificates

**Link:** [Backup Certificates](https://developers.cloudflare.com/ssl/edge-certificates/backup-certificates/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Can opt out?**

Enterprise-only

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Custom Certificates

**Link:** [Custom Certificates](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Certificates included**

* **Free:** 0
* **Lite:** 0
* **Pro:** 0
* **Pro Plus:** 1
* **Business:** 1 Modern and 1 Legacy
* **Enterprise:** 1 Modern (can purchase more) and 1 Legacy (can purchase more)

### Always Use HTTPS

**Link:** [Always Use HTTPS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Automatic HTTPS Rewrites

**Link:** [Automatic HTTPS Rewrites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/automatic-https-rewrites/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Certificate Transparency Monitoring

**Link:** [Certificate Transparency Monitoring](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/certificate-transparency-monitoring/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Email Recipients**

* **Free:** All account members
* **Lite:** All account members
* **Pro:** All account members
* **Pro Plus:** All account members
* **Business:** Specified email addresses
* **Enterprise:** Specified email addresses

### Opportunistic Encryption

**Link:** [Opportunistic Encryption](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/opportunistic-encryption/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### HTTP Strict Transport Security

**Link:** [HTTP Strict Transport Security](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/http-strict-transport-security/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### TLS 1.3

**Link:** [TLS 1.3](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/tls-13/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Minimum TLS Version

**Link:** [Minimum TLS Version](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/minimum-tls/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Per-hostname**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Lite:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro Plus:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Certificate Signing Requests

**Link:** [Certificate Signing Requests](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/certificate-signing-requests/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Custom Hostnames

**Link:** [Custom Hostnames](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/plans/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Contact your account team

**Hostnames included**

Varies

* **Free:** 100
* **Lite:** 100
* **Pro:** 100
* **Pro Plus:** 100
* **Business:** 100
* **Enterprise:** Custom

**Max hostnames**

* **Free:** 50,000
* **Lite:** 50,000
* **Pro:** 50,000
* **Pro Plus:** 50,000
* **Business:** 50,000
* **Enterprise:** Unlimited, but contact sales if using over 50,000.

**Price per additional hostname**

* **Free:** $0.10
* **Lite:** $0.10
* **Pro:** $0.10
* **Pro Plus:** $0.10
* **Business:** $0.10
* **Enterprise:** Custom pricing

**[Custom analytics](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/hostname-analytics/)**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**[Custom origin](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/custom-origin/)**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**[SNI Rewrite for Custom Origin](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/custom-origin/#sni-rewrites)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Contact your account team

**[Custom certificates](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/custom-certificates/)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**[CSR support](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/custom-certificates/certificate-signing-requests/)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**[Selectable CA](https://developers.cloudflare.com/ssl/reference/certificate-authorities/)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Wildcard custom hostnames**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**Non-SNI support for SaaS zone**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**[mTLS support](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/enforce-mtls/)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

**[WAF for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/waf-for-saas/)**

* **Free:** WAF rules with current zone plan
* **Lite:** WAF rules with current zone plan
* **Pro:** WAF rules with current zone plan
* **Pro Plus:** WAF rules with current zone plan
* **Business:** WAF rules with current zone plan
* **Enterprise:** Create and apply custom firewall rulesets.

**[Apex proxying/BYOIP](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/apex-proxying/)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

**[Custom metadata](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/custom-metadata/)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

### Custom origin trust store

**Link:** [Custom origin trust store](https://developers.cloudflare.com/ssl/origin-configuration/custom-origin-trust-store/)

**Feature availability**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Lite:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro Plus:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### SSL/TLS encryption mode

**Link:** [SSL/TLS encryption mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Strict (SSL-Only Origin Pull)**

Enterprise-only

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Keyless SSL

**Link:** [Keyless SSL](https://developers.cloudflare.com/ssl/keyless-ssl/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Paid add-on

### Origin certificates

**Link:** [Origin certificates](https://developers.cloudflare.com/ssl/origin-configuration/origin-ca/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Staging environment

**Link:** [Staging environment](https://developers.cloudflare.com/ssl/edge-certificates/staging-environment/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes (open beta)

### SSL/TLS Recommender

**Link:** [SSL/TLS Recommender](https://developers.cloudflare.com/ssl/origin-configuration/ssl-tls-recommender/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Custom cipher suites

**Link:** [Custom cipher suites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/cipher-suites/customize-cipher-suites/)

**Feature availability**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Lite:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro Plus:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Total TLS

**Link:** [Total TLS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/)

**Feature availability**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Lite:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro Plus:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Delegated DCV

**Link:** [Delegated DCV](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/delegated-dcv/)

**Feature availability**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Lite:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro Plus:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Universal Certificates

**Link:** [Universal Certificates](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Client Certificates

**Link:** [Client Certificates](https://developers.cloudflare.com/ssl/client-certificates/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Client Certificates included, issued by a Cloudflare Managed CA**

* **Free:** 100
* **Lite:** 100
* **Pro:** 100
* **Pro Plus:** 100
* **Business:** 100
* **Enterprise:** 100 (default), but can allocate more quota.

**[Bring your own CA](https://developers.cloudflare.com/ssl/client-certificates/byo-ca/)**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

## Support

### Ticket Support

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Initial ticket response time**

* **Free:** N/A
* **Lite:** N/A
* **Pro:** N/A
* **Pro Plus:** N/A
* **Business:** 8-72 hrs (P1-P4 issues)
* **Enterprise:** 1hr (urgent issues)

### Chat Support

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

### 24x7x365 Emergency Phone Support

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Yes

### Uptime guarantees

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

**SLA**

* **Free:** N/A
* **Lite:** N/A
* **Pro:** N/A
* **Pro Plus:** N/A
* **Business:** 100%
* **Enterprise:** 100%

**Service credits**

* **Free:** N/A
* **Lite:** N/A
* **Pro:** N/A
* **Pro Plus:** N/A
* **Business:** 1x
* **Enterprise:** 10x (Standard) 25x (Premium)

## Traffic

### Argo Smart Routing

**Link:** [Argo Smart Routing](https://developers.cloudflare.com/argo-smart-routing/)

**Feature availability**

* **Free:** Paid add-on
* **Lite:** Paid add-on
* **Pro:** Paid add-on
* **Pro Plus:** Paid add-on
* **Business:** Paid add-on
* **Enterprise:** Paid add-on

### Health checks

**Link:** [Health checks](https://developers.cloudflare.com/health-checks/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of checks**

* **Free:** 0
* **Lite:** 0
* **Pro:** 10
* **Pro Plus:** 10
* **Business:** 50
* **Enterprise:** 1,000

**Analytics**

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Load Balancing

**Link:** [Load Balancing](https://developers.cloudflare.com/load-balancing/)

**Feature availability**

* **Free:** Paid add-on
* **Lite:** Paid add-on
* **Pro:** Paid add-on
* **Pro Plus:** Paid add-on
* **Business:** Paid add-on
* **Enterprise:** Paid add-on

**Analytics**

Pro and above

* **Free:** No
* **Lite:** No
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Custom rules**

* **Free:** 1 per hostname
* **Lite:** 1 per hostname
* **Pro:** 1 per hostname
* **Pro Plus:** 1 per hostname
* **Business:** 1 per hostname
* **Enterprise:** Varies

**Origin servers**

* **Free:** Up to 20
* **Lite:** Up to 20
* **Pro:** Up to 20
* **Pro Plus:** Up to 20
* **Business:** Up to 20
* **Enterprise:** Custom

### Waiting Room

**Link:** [Waiting Room](https://developers.cloudflare.com/waiting-room/)

**Feature availability**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

**Number of rooms**

Business and above

* **Free:** 0
* **Lite:** 0
* **Pro:** 0
* **Pro Plus:** 0
* **Business:** 1
* **Enterprise:** 1 (default) *With advanced:* Custom (can purchase more)

**Customized templates**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Advanced add-on

**Queueing methods**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** First In First Out (FIFO)
* **Enterprise:** First In First Out (FIFO) (default) *With advanced:* FIFO, Random, Reject, Passthrough

**Configure multiple hostnames and paths**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Advanced add-on

**Disable session renewal**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Advanced add-on

**JSON-friendly response**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Advanced add-on

**Customize queuing status code**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

**Scheduled events**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Advanced add-on

**Waiting Room rules**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Advanced add-on

**Session Revocation**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** No
* **Enterprise:** Advanced add-on

**SEO Crawler Bypassing**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Yes
* **Enterprise:** Yes

**Turnstile Widget Mode**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Invisible only
* **Enterprise:** Invisible (default) *With advanced:* Invisible, Managed, Non Interactive

**Turnstile Fail Action**

* **Free:** No
* **Lite:** No
* **Pro:** No
* **Pro Plus:** No
* **Business:** Log only
* **Enterprise:** Log only (default) *With advanced:* Log only & Infinite queue

## Web3

### IPFS Gateways

**Link:** [IPFS Gateways](https://developers.cloudflare.com/web3/ipfs-gateway/)

**Feature availability**

* **Free:** Yes (Usage-based billing)
* **Lite:** Yes (Usage-based billing)
* **Pro:** Yes (Usage-based billing)
* **Pro Plus:** Yes (Usage-based billing)
* **Business:** Yes (Usage-based billing)
* **Enterprise:** Yes (Usage-based billing)

**Total gateways**

* **Free:** 15
* **Lite:** 15
* **Pro:** 15
* **Pro Plus:** 15
* **Business:** 15
* **Enterprise:** Unlimited

**Gateway types**

* **Free:** [DNSLink](https://developers.cloudflare.com/web3/ipfs-gateway/concepts/dnslink/)
* **Lite:** [DNSLink](https://developers.cloudflare.com/web3/ipfs-gateway/concepts/dnslink/)
* **Pro:** [DNSLink](https://developers.cloudflare.com/web3/ipfs-gateway/concepts/dnslink/)
* **Pro Plus:** [DNSLink](https://developers.cloudflare.com/web3/ipfs-gateway/concepts/dnslink/)
* **Business:** [DNSLink](https://developers.cloudflare.com/web3/ipfs-gateway/concepts/dnslink/)
* **Enterprise:** [DNSLink](https://developers.cloudflare.com/web3/ipfs-gateway/concepts/dnslink/), [Universal Gateway](https://developers.cloudflare.com/web3/ipfs-gateway/concepts/universal-gateway/)

**Included bandwidth (without additional cost)**

* **Free:** 50 GB data transfer
* **Lite:** 50 GB data transfer
* **Pro:** 50 GB data transfer
* **Pro Plus:** 50 GB data transfer
* **Business:** 50 GB data transfer
* **Enterprise:** 100 GB data transfer

**File size limit**

* **Free:** None
* **Lite:** None
* **Pro:** None
* **Pro Plus:** None
* **Business:** None
* **Enterprise:** None

### Ethereum Gateways

**Link:** [Ethereum Gateways](https://developers.cloudflare.com/web3/ethereum-gateway/)

**Feature availability**

* **Free:** Yes (Usage-based billing)
* **Lite:** Yes (Usage-based billing)
* **Pro:** Yes (Usage-based billing)
* **Pro Plus:** Yes (Usage-based billing)
* **Business:** Yes (Usage-based billing)
* **Enterprise:** Yes (Usage-based billing)

**Total gateways**

* **Free:** 15
* **Lite:** 15
* **Pro:** 15
* **Pro Plus:** 15
* **Business:** 15
* **Enterprise:** Unlimited

**Included bandwidth (without additional cost)**

* **Free:** 500,000 HTTP requests
* **Lite:** 500,000 HTTP requests
* **Pro:** 500,000 HTTP requests
* **Pro Plus:** 500,000 HTTP requests
* **Business:** 500,000 HTTP requests
* **Enterprise:** 1,000,000 HTTP requests

## Zaraz

### Zaraz

**Link:** [Zaraz](https://developers.cloudflare.com/zaraz/)

**Feature availability**

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Consent Management**

Available on all plans

* **Free:** Yes
* **Lite:** Yes
* **Pro:** Yes
* **Pro Plus:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Preview mode**

Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)

* **Free:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Lite:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Pro:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Pro Plus:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Business:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Enterprise:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)

**History**

Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)

* **Free:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Lite:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Pro:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Pro Plus:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Business:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)
* **Enterprise:** Included with a [Workers Paid Plan](https://developers.cloudflare.com/workers/platform/pricing/)

## Missing features

This page is meant to be a companion to our [Plans and Pricing page](https://www.cloudflare.com/plans/), but is not meant to be comprehensive. In the event of any inconsistency between this page and the Plans and Pricing page, the Plans and Pricing page controls.

Refer to the following locations for more information:

* **Developer products**: Refer to the [Developer Platform pricing page](https://www.cloudflare.com/plans/developer-platform/) or individual [product docs](https://developers.cloudflare.com/directory/) to learn more about plans and pricing.
* **Zero Trust products**: Refer to the [Zero Trust pricing](https://www.cloudflare.com/plans/zero-trust-services/) page.
* **Other products**: Refer to the individual [product docs](https://developers.cloudflare.com/directory/) to learn more about plans and pricing.
